/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.secrets_of_forging_revelations.item;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class ModularPolearm
extends ItemModularHandheld {
    public static final String headKey = "polearm/head";
    public static final String handleKey = "polearm/handle";
    public static final String bindingKey = "polearm/binding";
    public static final String identifier = "modular_polearm";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(new int[]{1, -3, -11, 21});
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(new int[]{-14, 0});
    @ObjectHolder(registryName="item", value="tetra:modular_polearm")
    public static ModularPolearm instance;

    public ModularPolearm() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41491_((CreativeModeTab)TetraItemGroup.instance));
        this.entityHitDamage = 1;
        this.majorModuleKeys = new String[]{headKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headKey};
        this.updateConfig((Integer)ConfigHandler.honeSingleBase.get(), (Integer)ConfigHandler.honeSingleIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic((UpgradeSchematic)new RepairSchematic((IModularItem)this, identifier));
        RemoveSchematic.registerRemoveSchematics((IModularItem)this, (String)identifier);
    }

    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("polearm/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":throwing";
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return "throwing";
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.setupPolearm("iron", "oak"));
        }
    }

    private ItemStack setupPolearm(String head, String handle) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)headKey, (String)"polearm/spearhead", (String)"polearm/spearhead_material", (String)("spearhead/" + head));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)handleKey, (String)"polearm/basic_handle", (String)"polearm/basic_handle_material", (String)("basic_handle/" + handle));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }
}

